#include <stdio.h>
#include <pthread.h>
#include <unistd.h>
#include <stdlib.h>
#include<time.h>

//BROJ VOIZLA IZ SMEROVA A I B
#define N_A 100
#define N_B 100

#define SMER_A -1
#define SMER_B 1
#define SMER_NEODREDJEN 0

//MUTEX STITI KRITICAN REGION
pthread_mutex_t NADVOZNJAK = PTHREAD_MUTEX_INITIALIZER;


//2 REDA CEKANJA ZA SVA VOZILA IZ OBA SMERA
// Kada bih hteo da maksimalno optimizujem program, koristio bih posebne redove po tipu i smeru vozila kako bih sprecio race condition,
// ali moje misljenje da je za ovaj zadatak sasvim dovoljno staviti redove po smeru
pthread_cond_t COND_A =  PTHREAD_COND_INITIALIZER;
pthread_cond_t COND_B =  PTHREAD_COND_INITIALIZER;

//Promenjlive radi optimizacije prilikom broadcasta signala. 
int ceka_A;
int ceka_B;

//Trenutno aktuelni smer prelaska nadvoznjaka
int smer = SMER_NEODREDJEN;

int brojVozila = 0;             //prati sva vozila na mostu
int brojAutobusa = 0;           //belezi prelazak autobusa
int brojKamiona = 0;            //belezi prelazak kamiona



void* prelazakSmerA(void * arg){
    long id = (long) arg;
    int tip = rand()%3;         //0-automobil; 1-autobus;2-kamion

    sleep(rand()%5);//simulacija dolaska vozila

    switch(tip)
    {
        case 0:
        //AUTOMOBIL
        printf("SMER A: %ld. automobil dolazi do nadvoznjaka\n",id);
        pthread_mutex_lock(&NADVOZNJAK);
        //Возило може започети прелазак уколико на надвожњаку нема возила из супротног смера.
        ceka_A++;
        while(smer == SMER_B || brojKamiona) 
        {
            pthread_cond_wait(&COND_A,&NADVOZNJAK);
        }
        ceka_A--;
        if(smer==SMER_NEODREDJEN)
        {
            smer=SMER_A;
            brojVozila=0;
        }
        brojVozila++;
        printf("SMER A: %ld. automobil prelazi nadvoznjak\t(na nadvoznjaku: %d)\n",id,brojVozila); //ispis se nalazi u mutexu radi lakseg pracenja izvrsavanja
        pthread_mutex_unlock(&NADVOZNJAK);
        //simulacija prelaska
        sleep(2);

        pthread_mutex_lock(&NADVOZNJAK);
        brojVozila--;
        printf("SMER A: %ld. automobil je presao nadvoznjak\t(na nadvoznjaku: %d)\n",id,brojVozila);
        
        if(!brojVozila)
        {
            //ako na nadvoznjaku nema voizila, proveravam da li neko ceka iz suprotnog smera
            if(ceka_B && !ceka_A)
            {
                smer=SMER_B;
                pthread_cond_broadcast(&COND_B);
            }
            else if(ceka_A)       
                pthread_cond_broadcast(&COND_A);
        }
        pthread_mutex_unlock(&NADVOZNJAK);
        break;

        case 1:
        //AUTOBUS
        printf("SMER A: %ld. autobus dolazi do nadvoznjaka\n",id);
        pthread_mutex_lock(&NADVOZNJAK);
        //Возило може започети прелазак уколико на надвожњаку нема возила из супротног смера.
        //у једном тренутку на њему не сме бити више од једног аутобуса.
        ceka_A++;
        while(smer == SMER_B || brojAutobusa || brojKamiona) 
        {
            pthread_cond_wait(&COND_A,&NADVOZNJAK);
        }
        ceka_A--;
        if(smer==SMER_NEODREDJEN)
        {
            smer=SMER_A;
            brojVozila=0;
        }
        brojVozila++;
        brojAutobusa++;
        printf("SMER A: %ld. autobus prelazi nadvoznjak\tna nadvoznjaku: %d\t(broj autobusa:%d)\n",id,brojVozila,brojAutobusa);
        pthread_mutex_unlock(&NADVOZNJAK);
        //simulacija prelaska
        sleep(2);

        pthread_mutex_lock(&NADVOZNJAK);
        brojVozila--;
        brojAutobusa--;
        printf("SMER A: %ld. autobus je presao nadvoznjak\tna nadvoznjaku: %d\t(broj autobusa:%d)\n",id,brojVozila,brojAutobusa);
        
        if(!brojVozila)
        {
            if(ceka_B && !ceka_A)
            {
                smer=SMER_B;
                pthread_cond_broadcast(&COND_B);
            }
            else if(ceka_A)
                pthread_cond_broadcast(&COND_A);
        }
        else{
            //Ako ceka neki 
        }
        pthread_mutex_unlock(&NADVOZNJAK);

        break;

        case 2:
        //KAMION
          printf("SMER A: %ld. kamion dolazi do nadvoznjaka\n",id);
        pthread_mutex_lock(&NADVOZNJAK);
        //камион мора бити једино возило на надвожњаку.
        ceka_A++;
        while(smer == SMER_B || brojVozila ) 
        {
            pthread_cond_wait(&COND_A,&NADVOZNJAK);
        }
        ceka_A--;
        if(smer==SMER_NEODREDJEN)
        {
            smer=SMER_A;
            brojVozila=0;
        }
        brojVozila++;
        brojKamiona++;
        printf("SMER A: %ld. kamion prelazi nadvoznjak\tna nadvoznjaku: %d\tbroj kamiona:%d\n",id,brojVozila,brojKamiona);
      
        //simulacija prelaska
        //nema potrebe otklucati mutex jer kamion mora jedini da prodje nadvoznjak
        // tako da ni uslov || brojKamiona nije potreban kod uslova cekanja za automobile i autobuse ali je tu radi dodatne sigurnosti
        sleep(2);

      
        brojVozila--;
        brojKamiona--;
        printf("SMER A: %ld. kamion je presao nadvoznjak\tna nadvoznjaku: %d\tbroj kamiona:%d\n",id,brojVozila,brojKamiona);
        
       if(!brojVozila)
        {
            if(ceka_B && !ceka_A)
            {
                smer=SMER_B;
                pthread_cond_broadcast(&COND_B);
            }
            else if(ceka_A)
                pthread_cond_broadcast(&COND_A);
        }
        pthread_mutex_unlock(&NADVOZNJAK);

        break;
    }

}

void* prelazakSmerB(void * arg){

      long id = (long) arg;

    int tip = rand()%3;

    sleep(rand()%5);

    switch(tip)
    {
        case 0:
        //AUTOMOBIL
        printf("SMER B: %ld. automobil dolazi do nadvoznjaka\n",id);
        pthread_mutex_lock(&NADVOZNJAK);
        //Возило може започети прелазак уколико на надвожњаку нема возила из супротног смера.
        ceka_B++;
        while(smer == SMER_A || brojKamiona) 
        {
            pthread_cond_wait(&COND_B,&NADVOZNJAK);
        }
        ceka_B--;
        if(smer==SMER_NEODREDJEN)
        {
            smer=SMER_B;
            brojVozila=0;
        }
       brojVozila++;
        printf("SMER B: %ld. automobil prelazi nadvoznjak\tna nadvoznjaku: %d\n",id,brojVozila);
        pthread_mutex_unlock(&NADVOZNJAK);
        //simulacija prelaska
        sleep(2);

        pthread_mutex_lock(&NADVOZNJAK);
        brojVozila--;
        printf("SMER B: %ld. automobil je presao nadvoznjak\tna nadvoznjaku: %d\n",id,brojVozila);
        
        if(!brojVozila)
        {
            if(ceka_A && !ceka_B)
            {
                smer=SMER_A;
                pthread_cond_broadcast(&COND_A);
            }
            else if(ceka_B)
                pthread_cond_broadcast(&COND_B);
        }
        pthread_mutex_unlock(&NADVOZNJAK);

        break;

        case 1:
        //AUTOBUS
        printf("SMER B: %ld. autobus dolazi do nadvoznjaka\n",id);
        pthread_mutex_lock(&NADVOZNJAK);
        //Возило може започети прелазак уколико на надвожњаку нема возила из супротног смера.
        //у једном тренутку на њему не сме бити више од једног аутобуса.
        ceka_B++;
        while(smer == SMER_A || brojAutobusa || brojKamiona) 
        {
            pthread_cond_wait(&COND_B,&NADVOZNJAK);
        }
        ceka_B--;
        
        if(smer==SMER_NEODREDJEN)
        {
            smer=SMER_B;
            brojVozila=0;
        }
        brojVozila++;
        brojAutobusa++;
        printf("SMER B: %ld. autobus prelazi nadvoznjak\tna nadvoznjaku: %d\tbroj autobusa:%d\n",id,brojVozila,brojAutobusa);
        pthread_mutex_unlock(&NADVOZNJAK);
        //simulacija prelaska
        sleep(2);

        pthread_mutex_lock(&NADVOZNJAK);
        brojVozila--;
        brojAutobusa--;
        printf("SMER B: %ld. autobus je presao nadvoznjak\tna nadvoznjaku: %d\tbroj autobusa:%d\n",id,brojVozila,brojAutobusa);
        
      if(!brojVozila)
        {
            if(ceka_A && !ceka_B)
            {
                smer=SMER_A;
                pthread_cond_broadcast(&COND_A);
            }
            else if(ceka_B)
                pthread_cond_broadcast(&COND_B);
        }
        pthread_mutex_unlock(&NADVOZNJAK);

        break;

        case 2:
        //KAMION
          printf("SMER B: %ld. kamion dolazi do nadvoznjaka\n",id);
        pthread_mutex_lock(&NADVOZNJAK);
        //камион мора бити једино возило на надвожњаку.
        ceka_B++;
        while(smer == SMER_A || brojVozila) 
        {
            pthread_cond_wait(&COND_B,&NADVOZNJAK);
        }
        ceka_B--;
        if(smer==SMER_NEODREDJEN)
        {
            smer=SMER_B;
            brojVozila=0;
        }
        brojVozila++;
        brojKamiona++;
        printf("SMER B: %ld. kamion prelazi nadvoznjak\tna nadvoznjaku: %d\tbroj kamiona:%d\n",id,brojVozila,brojKamiona);
      
        //simulacija prelaska
        sleep(2);

        brojVozila--;
        brojKamiona--;
        printf("SMER B: %ld. kamion je presao nadvoznjak\tna nadvoznjaku: %d\tbroj kamiona:%d\n",id,brojVozila,brojKamiona);
       if(!brojVozila)
        {
            if(ceka_A && !ceka_B)
            {
                smer=SMER_A;
                pthread_cond_broadcast(&COND_A);
            }
            else if(ceka_B)
                pthread_cond_broadcast(&COND_B);
        }
        pthread_mutex_unlock(&NADVOZNJAK);

        break;
    }
}



int main()
{

    pthread_t threads[N_A+N_B];

    for(long i = 0;i<N_A;i++)
    {
        pthread_create(threads +i,NULL,prelazakSmerA,(void*) i);
    }
    
    for(long i = N_A;i<N_A+N_B;i++)
    {
        pthread_create(threads +i,NULL,prelazakSmerB,(void*) i);
    }
    pthread_exit(NULL);

}
